% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtering.R
\name{rnb.execute.na.removal}
\alias{rnb.execute.na.removal}
\title{rnb.execute.na.removal}
\usage{
rnb.execute.na.removal(
  rnb.set,
  threshold = rnb.getOption("filtering.missing.value.quantile")
)
}
\arguments{
\item{rnb.set}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBSet}}.}

\item{threshold}{Maximum quantile of \code{NA}s allowed per site. This must be a value between 0 and 1.}
}
\value{
List of four or five elements:
        \describe{
          \item{\code{"dataset.before"}}{Copy of \code{rnb.set}.}
          \item{\code{"dataset"}}{The (possibly modified) dataset after performing the missing value removal.}
          \item{\code{"filtered"}}{\code{integer} vector storing the indices (in beta matrix of the unfiltered
               dataset) of all removed sites.}
			 \item{\code{"threshold"}}{Copy of \code{threshold}.}
			 \item{\code{"naCounts"}}{Vector storing the number of NAs per site}
        }
}
\description{
Removes all probes with missing value (if such exists) from the given dataset.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
rnb.set.filtered <- rnb.execute.na.removal(rnb.set.example, 0)$dataset
identical(meth(rnb.set.example), meth(rnb.set.filtered)) # TRUE
}
}
\author{
Yassen Assenov
}
