% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filtering.R
\name{rnb.execute.low.coverage.masking}
\alias{rnb.execute.low.coverage.masking}
\title{rnb.execute.low.coverage.masking}
\usage{
rnb.execute.low.coverage.masking(
  rnb.set,
  covg.threshold = rnb.getOption("filtering.coverage.threshold")
)
}
\arguments{
\item{rnb.set}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBSet}}.}

\item{covg.threshold}{Threshold for minimal acceptable coverage, given as a non-negative \code{integer} value. All
methylation measurements with lower coverage than this threshold are set to \code{NA}. If this
parameter is \code{0}, calling this method has no effect.}
}
\value{
List of three elements:
        \describe{
          \item{\code{"dataset.before"}}{Copy of \code{rnb.set}.}
          \item{\code{"dataset"}}{The (possibly) modified dataset after retaining sites on autosomes only.}
          \item{\code{"mask"}}{A logical matrix of dimension \code{meth(rnb.set,type="sites")} indicating which
				   methylation values have been masked}
        }
}
\description{
Replaces all low coverage sites by \code{NA}.
}
\author{
Fabian Mueller
}
