% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading.R
\name{rnb.execute.import}
\alias{rnb.execute.import}
\title{rnb.execute.import}
\usage{
rnb.execute.import(
  data.source,
  data.type = rnb.getOption("import.default.data.type"),
  dry.run = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{data.source}{non-empty \code{character} vector or \code{list} specifying the location of the data items. The
expected format depends on the \code{data.type} that is given. See the \emph{Details} section.}

\item{data.type}{type of the input data; must be one of \code{"idat.dir"}, \code{"data.dir"}, \code{"data.files"},
\code{"GS.report"}, \code{"GEO"} or \code{"rnb.set"}.}

\item{dry.run}{if \code{TRUE} and \code{data.type} is \code{"bs.bed.dir"}, only a test data import is performed and first 10,000 lines are read from each BED file}

\item{verbose}{flag specifying whether diagnostic output should be written to the console or to the RnBeads logger
in case the latter is initialized}
}
\value{
Loaded data as an object of type \code{\linkS4class{RnBSet}} (when the input data type is
        \code{"data.dir"}, \code{"data.files"} or \code{"GEO"}) or of type \code{\linkS4class{MethyLumiSet}} (when
        the data type is \code{"idat.dir"} or \code{"GS.report"}).
}
\description{
Loads the data from the specified type and encapsulates it in either an \code{\linkS4class{RnBSet}}-inheriting object
}
\details{
The interpretation of \code{data.source} depends on the value of \code{data.type} and is summarized in the
following table:
\tabular{lccl}{
  \bold{\code{data.type}} \tab \bold{Type of \code{data.source}} \tab \bold{Maximal length of \code{data.source}} \tab
    \bold{Interpretation}\cr
  \code{"infinium.idat.dir"}  \tab \code{list} or \code{character} \tab \code{2}       \tab
    (1) Directory containing IDAT files; (2) a sample annotation table as a \code{data.frame} or the name of the corresponding file\cr
  \code{"infinium.data.dir"}  \tab \code{character} \tab \code{1} \tab
   Directory containing data tables in plain text format. The directory should contain one file with \code{Sample|sample} token in the filename
for the table of sample annotations, and one file with a token \code{beta} in the filename, with beta-values. It may also contain tables with p-values
(token \code{pval}) and bead counts (\code{bead}). In the latter case beta-value, p-value and bead count tables should have matching columns and rows.
The beta-value, p-value and bead-count tables should contain row names, i.e. the first column should contain the Infinium CG identifiers and not have
a column header (for that the first row should have one entry less than all other rows). Sample annotation table should contain as many rows as there are
columns in other tables. The character used as value separator in the text tables can be set using the \code{import.table.separator} option
(see \code{\link{rnb.options}} for details). \cr
	 \code{"infinium.data.files"} \tab \code{character} \tab \code{2..4} \tab
	The character vector should contain at least full paths to the sample annotation file and beta-value table. Detection p-values and bead counts table
 can be added as the third and the fourth elements. The table format requirements are the same as for \code{"data.dir"} above.\cr
  \code{"infinium.GS.report"} \tab \code{character}                \tab \code{1}       \tab
    Genome Studio report file\cr
  \code{"infinium.GEO"}       \tab \code{character}                \tab \code{1}       \tab
    \href{http://www.ncbi.nlm.nih.gov/geo/}{GEO} identifier or downloaded series matrix file\cr
  \code{"bs.bed.dir"}       \tab \code{list} or \code{character}                \tab \code{1..3}       \tab
    (1) Directory with BED files each giving a DNA methylation profile of a sample; (2) a sample annotation table as a \code{data.frame} or the name of the corresponding file;
		(3) number of the sample annotation sheet column containing the file names. One of the first two elements have to be present. In case only the directory is specified,
		it should contain a sample annotation file with a token "sample" in the file name. In case only the sample sheet is specified, one column should be giving full absolute paths
		of the BED-like files with sequencing information. If both elements (1) and (2) are specified, the files should reside in the directory, specified as element (1).
		If the third element is absent, an attempt will be made to find the file name containing column automatically. For this reason the file names in the sample annotation sheet
		should be given with extensions (".bed", ".cov" etc).\cr
 \code{"rnb.set"}       \tab \code{\linkS4class{RnBSet}}                \tab \code{1}       \tab
    object of class inheriting from \code{\linkS4class{RnBSet}}\cr
}
}
\examples{
\donttest{
# Directory where your data is located
data.dir <- "~/RnBeads/data/Ziller2011_PLoSGen_450K"
idat.dir <- file.path(data.dir, "idat")
sample.annotation <- file.path(data.dir, "sample_annotation.csv")
data.source <- c(idat.dir, sample.annotation)
rnb.set <- rnb.execute.import(data.source = data.source, data.type = "idat.dir")
}
}
\seealso{
\code{\link{read.data.dir}}, \code{\link{read.idat.files}}, \code{\link{read.GS.report}},
         \code{\link{rnb.read.geo}}, \code{\link{read.bed.files}}
#'
}
\author{
Pavlo Lutsik
}
