% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialMethylation.R
\name{rnb.execute.computeDiffMeth}
\alias{rnb.execute.computeDiffMeth}
\title{rnb.execute.computeDiffMeth}
\usage{
rnb.execute.computeDiffMeth(
  x,
  pheno.cols,
  region.types = rnb.region.types.for.analysis(x),
  covg.thres = rnb.getOption("filtering.coverage.threshold"),
  pheno.cols.all.pairwise = rnb.getOption("differential.comparison.columns.all.pairwise"),
  columns.pairs = rnb.getOption("columns.pairing"),
  columns.adj = rnb.getOption("covariate.adjustment.columns"),
  adjust.sva = rnb.getOption("differential.adjustment.sva"),
  pheno.cols.adjust.sva = rnb.getOption("inference.targets.sva"),
  adjust.celltype = rnb.getOption("differential.adjustment.celltype"),
  skip.sites = !rnb.getOption("analyze.sites"),
  disk.dump = rnb.getOption("disk.dump.big.matrices"),
  disk.dump.dir = tempfile(pattern = "diffMethTables_"),
  ...
)
}
\arguments{
\item{x}{RnBSet object}

\item{pheno.cols}{column names of the pheno slot in \code{x} on which the dataset should be partitioned. Those columns are required to be factors or logical.
In case of factors, each group in turn will be compared to all other groups}

\item{region.types}{which region types should be processed for differential methylation}

\item{covg.thres}{coverage threshold for computing the summary statistics. See \code{\link{computeDiffTab.extended.site}} for details.}

\item{pheno.cols.all.pairwise}{integer or character vector specifying the colomns of \code{pheno(x)} on which all pairwise comparisons should be conducted.
A value of \code{NULL} (default) indicates no columns.}

\item{columns.pairs}{argument passed on to \code{rnb.sample.groups}. See its documentation for details.}

\item{columns.adj}{Column names or indices in the table of phenotypic information to be used for confounder adjustment in the
differential methylation analysis.}

\item{adjust.sva}{flag indicating whether the adjustment table should also contain surrogate variables (SVs) for the given target variable.}

\item{pheno.cols.adjust.sva}{Column names or indices in the table of phenotypic information to be used for SVA adjustment in the
differential methylation analysis.}

\item{adjust.celltype}{flag indicating whether the resulting table should also contain estimated celltype contributions.
See \code{\link{rnb.execute.ct.estimation}} for details.}

\item{skip.sites}{flag indicating whether differential methylation in regions should be computed directly and not from sites. This leads to skipping of site-specific differential methylation}

\item{disk.dump}{Flag indicating whether the resulting differential methylation object should be file backed, ie.e the matrices dumped to disk}

\item{disk.dump.dir}{disk location for file backing of the resulting differential methylation object. Only meaningful if \code{disk.dump=TRUE}.
must be a character specifying an NON-EXISTING valid directory.}

\item{...}{arguments passed on to binary differential methylation calling. See \code{\link{computeDiffTab.extended.site}} for details.}
}
\value{
an \code{\linkS4class{RnBDiffMeth}} object. See class description for details.
}
\description{
computes differential methylation
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
dm <- rnb.execute.computeDiffMeth(rnb.set.example,pheno.cols=c("Sample_Group","Treatment"))
get.comparisons(dm)
}
}
\author{
Fabian Mueller
}
