% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Report-methods.R
\name{rnb.add.list}
\alias{rnb.add.list}
\title{rnb.add.list}
\usage{
rnb.add.list(report, txt, type = "u")
}
\arguments{
\item{report}{Report to write the text to.}

\item{txt}{Non-empty list of items to be written. An attribute named \code{type}, if it exists, specifies the type
of the list. See the \emph{Details} section for more information. Every item must be either a nested
\code{list}, denoting a sublist, or a \code{character} vector (or array), storing the text to be
written. Any other objects are coerced to a character type. Elements are concatenated without a
separator to form the text for a list item.}

\item{type}{List type to be used for the list and/or its sublists in case the attribute \code{type} is not
specified.}
}
\value{
The modified report, invisibly.
}
\description{
Generates HTML code for a list in the specified report.
}
\details{
There are two ways to specify a list type: (1) setting a value for the attribute \code{type} of the list, or
         (2) using the function's parameter \code{type}. The value of the function's parameter is used only for lists
         and sublists that do not contain an attribute named \code{type}. The following types are supported:
         \describe{
           \item{\code{"o"}}{Ordered list using arabic numbers - \code{1}, \code{2}, \code{3}, etc.}
           \item{\code{"u"}}{Unordered list using bullet points.}
         }
         Note that every list type must be a one-element \code{character} vector containing one of the codes listed
         above. Specifying any other value for list type results in an error.
}
\examples{
\donttest{
report <- createReport("example.html", "Example", init.configuration = TRUE)
recipe <- list("Sift flour in a bowl", "Add sugar and mix", "Add milk and mix")
rnb.add.list(report, recipe, type="o")
}
}
\seealso{
\code{\linkS4class{Report}} for other functions adding contents to an HTML report
}
\author{
Yassen Assenov
}
