% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataExport.R
\name{rnb.RnBSet.to.bed}
\alias{rnb.RnBSet.to.bed}
\title{Export to BED files}
\usage{
rnb.RnBSet.to.bed(
  rnb.set,
  out.dir,
  reg.type = "sites",
  names.quant.meth = TRUE,
  add.track.line = TRUE,
  lexicographic = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{rnb.set}{Methylation dataset as an object of type inheriting \code{\linkS4class{RnBSet}}.}

\item{out.dir}{Output directory. If not existing, it will be created. otherwise files in that directory are overwritten.}

\item{reg.type}{Region type to be extracted.}

\item{names.quant.meth}{should the names of the bed regions contain information on the methylation level.
If TRUE the following format is applied: meth_percent%[coverage]. Coverage is available only when
 \code{covg(rnb.set)} is not NULL}

\item{add.track.line}{Add a track line to the bed file to enable browsers like IGV to display the data better}

\item{lexicographic}{Should lexicographic ordering be used for chromosome names}

\item{verbose}{More detailed logger output}
}
\value{
(invisibly) a summary list containing information on the conversion step.
        elements are \code{filenames} (a table containing information on which sample has been written to what filename)
        and \code{assembly} (a string indicating the assembly used by \code{rnb.set}).
}
\description{
Exports the beta values from a methylation dataset to BED files.
}
\details{
Details on the BED file format can be found in the \href{http://genome.ucsc.edu/FAQ/FAQformat.html}{UCSC Genome Browser
         documentation}.  Each methylation site is an entry in the resulting bed file. The Score column corresponds
         to a site's methylation value in the interval \code{[0,1]}.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
rnb.RnBSet.to.bed(rnb.set.example,tempdir())
}
}
\author{
Fabian Mueller
}
