% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataImport.R
\name{read.single.bed}
\alias{read.single.bed}
\title{read.single.bed}
\usage{
read.single.bed(
  file,
  chr.col = 1L,
  start.col = 2L,
  end.col = 3L,
  strand.col = 6L,
  mean.meth.col = 7L,
  coverage.col = 8L,
  c.col = NA,
  t.col = NA,
  is.epp.style = FALSE,
  coord.shift = 0L,
  ffread = FALSE,
  context = "cg",
  ...
)
}
\arguments{
\item{file}{the input BED file}

\item{chr.col}{chromosome column index}

\item{start.col}{start column index}

\item{end.col}{end column index}

\item{strand.col}{strand column index}

\item{mean.meth.col}{mean methylation column index}

\item{coverage.col}{column with coverage information}

\item{c.col}{converted C counts column index}

\item{t.col}{unconverted C counts column index}

\item{is.epp.style}{Flag for custom Broad Epigenome Pipeline (EPP) bed style (columns \code{"chrom"}, \code{"start"},
\code{"end"}, \code{"methylated_count/total_count"}, \code{"meth_score_scaled_0_1000"} and
\code{"strand"} in this order). Setting this to \code{TRUE} overwrites all other parameters except
\code{file}, and also neglects \code{...}.}

\item{coord.shift}{An integer specifying the coordinate adjustment applied to the start and end coordinates.}

\item{ffread}{Use \code{ff} package functionality}

\item{context}{prefix for the output rownames}

\item{...}{further arguments to \code{read.table} or \code{read.table.ffdf}}
}
\value{
a \code{data.frame} or \code{ff.data.frame} object with DNA methylation and coverage information. The row names are formed by the following convension:
 		\code{context\\.read.delim(file,...)[,chr.col]\\.read.delim(file,...)[,start.col]\\.read.delim(file,...)[,strand.col]}.
}
\description{
reads a BED file with methylation information
}
\details{
Missing columns should be assigned with \code{NA}. In case \code{mean.meth.col} is absent at least \code{coverage.col}
			and one of \code{c.col} or \code{t.col} should be specified.
}
\author{
Pavlo Lutsik
}
