% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataImport.R
\name{read.idat.files}
\alias{read.idat.files}
\title{read.idat.files}
\usage{
read.idat.files(
  base.dir,
  barcodes = NULL,
  sample.sheet = NULL,
  sep.samples = rnb.getOption("import.table.separator"),
  dpval.method = "controls",
  useff = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{base.dir}{Directory that contains the \code{.idat} files to be read; or a character vector of such
directories.}

\item{barcodes}{Optional non-empty \code{character} vector listing the barcodes of the samples that should be
loaded. If supplied, this vector must not contain \code{NA} among its elements.}

\item{sample.sheet}{Optional file name containing a table of sample annotation data, or the table itself in the
form of a \code{\link{data.frame}} or \code{matrix}. Only (and all) samples defined in this
table will be loaded. The table is expected to contain a column named \code{"barcode"} that
lists the samples' Sentrix  barcodes. If such a column is not present, this function searches
for columns \code{"Sentrix_ID"} and \code{"Sentrix_Position"} (or similar) that build a
barcode.}

\item{sep.samples}{\code{character} string used as field separator in the sample sheet file.
Default value is taken by the call to \code{rnb.getOption("import.table.separator")}}

\item{dpval.method}{\code{character} indicating which method is to be used to compute detection p-values
By default, \code{'controls'} uses the built-in control probes, while the
\code{'pOOBAH'} method from the sesame package is also available.}

\item{useff}{If \code{TRUE} \code{ff} package is used to store large matrices on the hard disk}

\item{verbose}{Flag specifying whether the messages to the logger should be sent. Note that the logger
must be initialized prior to calling this function. Logging is useful for keeping a
record of the downloaded and processed samples. Also, informative messages are
stored in case of an error.}
}
\value{
Loaded dataset of HumanMethylation450K samples, encapsulated in an object of type \code{MethyLumiSet}.
}
\description{
Reads a directory of \code{.idat} files and initializes an object of type \code{\linkS4class{MethyLumiSet}}.
}
\details{
If neither \code{barcodes}, nor \code{sample.sheet} are specified, the function attempts to locate a file in
\code{base.dir} containing sample annotation information. It fails ifsuch a file cannot be (unambiguously)
identified. If both \code{barcodes} and \code{sample.sheet} are supplied, only \code{sample.sheet} is used in loading
methylation data. The value of \code{barcodes} is tested for validity but it is not used as a filter.
}
\seealso{
\code{\link{methylumIDAT}} in package \pkg{methylumi}
}
\author{
Pavlo Lutsik
}
