% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataImport.R
\name{read.GS.report}
\alias{read.GS.report}
\title{read.GS.report}
\usage{
read.GS.report(
  gsReportFile,
  pd = NULL,
  sep = rnb.getOption("import.table.separator"),
  keep.methylumi = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{gsReportFile}{location of the GS report file}

\item{pd}{alternative sample annotation, if the \code{gsReporFile} is missing the sample section as
\code{data.frame} of \code{character} singleton with the file name}

\item{sep}{character used as field separator in the sample sheet file and in the GS report file
 (should be identical).
Default value is taken by the call to \code{rnb.getOption("import.table.separator")}}

\item{keep.methylumi}{a flag indicating whether the a \code{MethyLumiSet}
object should be returned instead of a \code{RnBeadRawSet}.}

\item{verbose}{Flag indicating ifthe messages to the logger should be sent. Note that the logger must be initialized prior to calling this function.
Logging is useful for keeping a record of the downloaded and processed samples. Also, informative messages are stored in case of an error.}
}
\value{
MethylumiSet object with the data from the report
}
\description{
Reads in a Genome Studio report, exported as a single file.
}
