% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{performGoEnrichment.diffMeth}
\alias{performGoEnrichment.diffMeth}
\title{performGoEnrichment.diffMeth}
\usage{
performGoEnrichment.diffMeth(
  rnbSet,
  diffmeth,
  ontologies = c("BP", "MF"),
  rank.cuts.region = c(100, 500, 1000),
  add.auto.rank.cut = TRUE,
  rerank = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{rnbSet}{RnBSet object for which dirrential methylation was computed}

\item{diffmeth}{RnBDiffMeth object. See \code{\link{RnBDiffMeth-class}} for details.}

\item{ontologies}{GO ontologies to use for enrichment analysis}

\item{rank.cuts.region}{Cutoffs for combined ranking that are used to determine differentially methylated regions}

\item{add.auto.rank.cut}{flag indicating whether an automatically computed cut-off should also be considered.}

\item{rerank}{For deterimining differential methylation: should the ranks be ranked again or should the absolute ranks be used.}

\item{verbose}{Enable for detailed status report}

\item{...}{arguments passed on to the parameters of \code{GOHyperGParams} from the \code{GOstats} package}
}
\value{
a DiffMeth.go.enrich object (S3) containing the following attributes
\item{region}{Enrichment information for differential methylation on the region level. See \code{GOHyperGresult} from the \code{GOstats} package for furthert details}
}
\description{
performs Geno Ontology (GO) enrichment analysis for a given differential methylation table.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
dm <- rnb.execute.computeDiffMeth(rnb.set.example,pheno.cols=c("Sample_Group","Treatment"))
res <- performGoEnrichment.diffMeth(rnb.set.example,dm)
}
}
\author{
Fabian Mueller
}
