% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBSet-class.R
\docType{methods}
\name{mval,RnBSet-method}
\alias{mval,RnBSet-method}
\alias{mval}
\title{mval-methods}
\usage{
\S4method{mval}{RnBSet}(object, type = "sites", row.names = FALSE, epsilon = 0)
}
\arguments{
\item{object}{dataset of interest.}

\item{type}{\code{character} singleton. If this is set to \code{"sites"} (default), DNA methylation information
for each available site is returned. Otherwise, this should be one of region types for for which
summarized DNA methylation information is computed in the given dataset.}

\item{row.names}{Flag indicating of row names are to be generated in the result.}

\item{epsilon}{Threshold of beta values to use when adjusting for potential M values close to +infinity or
-infinity. See \code{\link{rnb.beta2mval}} for more details.}
}
\value{
\code{matrix} with methylation M values.
}
\description{
Extracts DNA methylation information (M values) for a specified set of genomic features.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
## per-site M-value matrix
mm<-mval(rnb.set.example, row.names=TRUE)
head(mm)
## M-values for each covered gene
gmm<-mval(rnb.set.example, type="gene", row.names=TRUE)
head(gmm)
}
}
\seealso{
\code{\link[=meth,RnBSet-method]{meth}} for extracting methylation beta values
}
