% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lolaUtils.R
\name{lolaVolcanoPlot}
\alias{lolaVolcanoPlot}
\title{lolaVolcanoPlot}
\usage{
lolaVolcanoPlot(
  lolaDb,
  lolaRes,
  includedCollections = c(),
  signifCol = "qValue",
  colorBy = "maxRnk",
  colorpanel = c()
)
}
\arguments{
\item{lolaDb}{LOLA DB object as returned by \code{LOLA::loadRegionDB} or \code{\link{loadLolaDbs}}}

\item{lolaRes}{LOLA enrichment result as returned by the \code{runLOLA} function from the \code{LOLA} package}

\item{includedCollections}{vector of collection names to be included in the plot. If empty (default), all collections are used}

\item{signifCol}{column name of the significance score in \code{lolaRes}. Should be one of \code{c("pValueLog", "qValue")}.}

\item{colorBy}{annotation/column in the the LOLA DB that should be used for point coloring}

\item{colorpanel}{colors to be used for coloring the points}
}
\value{
ggplot object containing the plot
}
\description{
plot a volcano plot showing LOLA enrichment results: LOLA p-value against the log-odds score. Colored by rank
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
# compute differential methylation
dm <- rnb.execute.computeDiffMeth(rnb.set.example,pheno.cols=c("Sample_Group","Treatment"))
# download LOLA DB
lolaDest <- tempfile()
dir.create(lolaDest)
lolaDirs <- downloadLolaDbs(lolaDest, dbs="LOLACore")
# perform enrichment analysis
res <- performLolaEnrichment.diffMeth(rnb.set.example,dm,lolaDirs[["hg19"]])
# select the 500 most hypermethylated tiling regions in ESCs compared to iPSCs
# in the example dataset
lolaRes <- res$region[["hESC vs. hiPSC (based on Sample_Group)"]][["tiling"]]
lolaRes <- lolaRes[lolaRes$userSet=="rankCut_500_hyper",]
# plot
lolaVolcanoPlot(res$lolaDb, lolaRes, signifCol="qValue")
}
}
\author{
Fabian Mueller
}
