% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{logger.argument}
\alias{logger.argument}
\title{logger.argument}
\usage{
logger.argument(
  arg.names,
  full.name,
  arg.type = "character",
  accepted.values = NULL,
  default = NULL,
  arg.list = commandArgs()
)
}
\arguments{
\item{arg.names}{\code{character} vector of acceptable argument names. This function scans the provided
arguments and performs a case insensitive match.}

\item{full.name}{One-element \code{character} vector giving the argument's full name or description. This is
used in a log message in case of an error.}

\item{arg.type}{Variable type of the argument. Must be one of \code{"character"}, \code{"logical"},
\code{"integer"}, \code{"double"}, \code{"numeric"} or \code{"real"}. The last three types are
all synonyms.}

\item{accepted.values}{Vector of accepted values for the argument. This must be of the type given in \code{arg.type}.
Set this to \code{NULL} if there are no restrictions on the argument values.}

\item{default}{Default value for the argument in case it is not specified. Setting this to \code{NULL} makes
the argument required, that is, an error is generated if the argument is not specified. Set
this to \code{NA} if is not a required argument and it shouldn't default to a specific value.
Otherwise, if \code{accepted.values} is provided, this must be one of its elements.}

\item{arg.list}{Vector of arguments provided at the execution of the script. The arguments should be provided
as \emph{name=value} pairs.}
}
\value{
Argument's value, or \code{NULL} if such is not provided.
}
\description{
Reads a command-line argument supplied to a script.
}
\details{
This is convenience function for reading parameters supplied to the script in the form \emph{name = value}.
         It expects that logging is enabled (see \code{\link{rnb.options}}). The function fails if this condition is
         not met.
}
\examples{
\donttest{
n.iterations <- logger.argument("iterations", "number of iterations", "integer",
  accepted.values = 1:100, default = 1L)
logger.close()
}
}
\author{
Yassen Assenov
}
