% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBDiffMeth-class.R
\docType{methods}
\name{is.valid,RnBDiffMeth-method}
\alias{is.valid,RnBDiffMeth-method}
\alias{is.valid}
\title{is.valid-methods}
\usage{
\S4method{is.valid}{RnBDiffMeth}(object, verbose = FALSE)
}
\arguments{
\item{object}{\code{\linkS4class{RnBDiffMeth}} object}

\item{verbose}{print more info to the logger}
}
\value{
TRUE iff all differential methylation tables are present and accounted for
}
\description{
Validate an RnBDiffMeth object, ie. verify that all differential methylation tables are specified
and accounted for
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
dm1 <- rnb.execute.computeDiffMeth(rnb.set.example,"Sample_Group",c("genes","tiling"))
dm2 <- rnb.execute.computeDiffMeth(rnb.set.example,c("Sample_Group","Treatment"),"promoters")
dm.join1 <- join.diffMeth(dm1,dm2)
#The following joint object is invalid due to missing region type - comparison combinations
is.valid(dm.join1)
dm3 <- rnb.execute.computeDiffMeth(rnb.set.example,c("Treatment"),c("genes","tiling"))
dm.join2 <- join.diffMeth(dm.join1,dm3)
#After joining the missing information, the new object is valid
is.valid(dm.join2)
}
}
\author{
Fabian Mueller
}
