% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lolaUtils.R
\name{getNamesFromLolaDb}
\alias{getNamesFromLolaDb}
\title{getNamesFromLolaDb}
\usage{
getNamesFromLolaDb(lolaDb, addCollectionNames = FALSE, addDbId = TRUE)
}
\arguments{
\item{lolaDb}{LOLA DB object as returned by \code{LOLA::loadRegionDB} or \code{\link{loadLolaDbs}}}

\item{addCollectionNames}{attach the name of the collection to the name}

\item{addDbId}{attach the index of the item in the LOLA DB object to the name}
}
\value{
character vector with human readable names
}
\description{
get human readable names from a LOLA DB object
}
\examples{
\donttest{
# download LOLA DB
lolaDest <- tempfile()
dir.create(lolaDest)
lolaDirs <- downloadLolaDbs(lolaDest, dbs="LOLACore")
lolaDb <- loadLolaDbs(lolaDirs[["hg19"]])
getNamesFromLolaDb(lolaDb)
}
}
\author{
Fabian Mueller
}
