% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBDiffMeth-class.R
\docType{methods}
\name{get.table,RnBDiffMeth-method}
\alias{get.table,RnBDiffMeth-method}
\alias{get.table}
\title{get.table-methods}
\usage{
\S4method{get.table}{RnBDiffMeth}(
  object,
  comparison,
  region.type,
  undump = TRUE,
  return.data.frame = FALSE
)
}
\arguments{
\item{object}{\code{\linkS4class{RnBDiffMeth}} object}

\item{comparison}{character or index of the comparison of the table to retrieve}

\item{region.type}{character or index of the region type of the table to retrieve}

\item{undump}{Flag indicating whether to convert the table into a matrix instead of using the file descriptor.
Only meaningful if the if the objects's \code{disk.dump} slot is true.}

\item{return.data.frame}{should a data.frame be returned instead of a matrix?}
}
\value{
differential methylation table. See \code{computeDiffMeth.bin.site} and \code{computeDiffMeth.bin.region} for details.
}
\description{
Gets a differential methylation table
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
dm <- rnb.execute.computeDiffMeth(rnb.set.example,pheno.cols=c("Sample_Group","Treatment"))
dm.promoters <- get.table(dm,get.comparisons(dm)[1],"promoters",return.data.frame=TRUE)
summary(dm.promoters)
}
}
\author{
Fabian Mueller
}
