% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sva.R
\name{get.covariates.sva}
\alias{get.covariates.sva}
\title{get.covariates.sva}
\usage{
get.covariates.sva(rnb.set, target)
}
\arguments{
\item{rnb.set}{\code{RnBSet} object}

\item{target}{target variable. Must be in \code{pheno(rnb.set)} and belong to target variables for which the
SVs have already been computed and stored in the RnBSet.}
}
\value{
an NxK table of K Surrogate variables stored for N samples of the \code{rnb.set}. \code{NULL}
	   if the components have not been computed or added to \code{rnb.set}.
}
\description{
Retrieves an NxK table of Surrogate variables stored in an RnBSet for a given target variable
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
sva.obj <- rnb.execute.sva(rnb.set.example,c("Sample_Group","Treatment"),numSVmethod="be")
sva.obj$sva.performed
sva.obj$num.components
rnb.set.mod <- set.covariates.sva(rnb.set.example, sva.obj)
get.covariates.sva(rnb.set.mod,"Sample_Group")
}
}
\author{
Fabian Mueller
}
