% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{data.frame2GRanges}
\alias{data.frame2GRanges}
\title{data.frame2GRanges}
\usage{
data.frame2GRanges(
  dframe,
  ids = rownames(dframe),
  chrom.column = "Chromosome",
  start.column = "Start",
  end.column = "End",
  strand.column = NULL,
  assembly = "hg19",
  sort.result = TRUE
)
}
\arguments{
\item{dframe}{Table defining genomic regions.}

\item{ids}{Region names (identifiers) as a \code{character} vector, or \code{NULL} if no names are present.}

\item{chrom.column}{Column name or index that lists the chromosome names.}

\item{start.column}{Column name or index that lists the start positions of the regions.}

\item{end.column}{Column name or index that lists the end positions of the regions.}

\item{strand.column}{Column name or index that lists the strands on which the regions are located. Set this to
\code{NULL} if this region set is not strand-specific.}

\item{assembly}{Genome assembly of interest. See \code{\link{rnb.get.assemblies}} for the list of supported
genomes.}

\item{sort.result}{Should the resulting table be sorted}
}
\value{
\code{GRanges} object encapsulating all well defined regions on supported chromosomes, contained in
        \code{dframe}. Columns other that the ones listed as parameters in this function are included as metadata.
}
\description{
Converts a \code{data.frame} that defines genomic regions to object of type \code{GRanges}.
}
\author{
Yassen Assenov
}
