% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReportPlot-methods.R
\name{createReportPlot}
\alias{createReportPlot}
\title{createReportPlot}
\usage{
createReportPlot(
  fname,
  report = NULL,
  width = 7,
  height = 7,
  create.pdf = TRUE,
  low.png = 100L,
  high.png = 0L
)
}
\arguments{
\item{fname}{\code{character} vector with one element storing the name of the output file, without the
extension. The initialized object appends \code{.pdf} and/or \code{.png} to this name.}

\item{report}{Report (object of type \code{\linkS4class{Report}}) to which this plot is going to be added. This
is used to set the directories for PDF and/or PNG files generated for these plots. If this
parameter is \code{NULL}, the current working directory is used to host all generated images.}

\item{width}{\code{numeric} storing the width of the device in inches. The length of this vector must be
\code{1}.}

\item{height}{\code{numeric} storing the height of the device in inches. The length of this vector must be
\code{1}.}

\item{create.pdf}{Flag indicating if a PDF image is to be created. The length of this vector must be \code{1}.}

\item{low.png}{Resolution, in dots per inch, used for the figure image. Set this to \code{0} or a negative value
to disable the creation of a low resolution image. The length of this vector must be \code{1}.}

\item{high.png}{Resolution, in dots per inch, used for a dedicated image. Set this to \code{0} or a negative value
to disable the creation of a high resolution image. The length of this vector must be \code{1}.}
}
\value{
Newly created \code{ReportPlot} object.
}
\description{
Initializes a report plot and opens a device to create it. The type of the device created depends on the
parameters \code{create.pdf}, \code{low.png} and \code{high.png}. If \code{create.pdf} is \code{TRUE}, a PDF device
is opened and its contents are later copied to PNG device(s) if needed. Otherwise, a PNG device is opened. Note that
at least one of the following conditions must be met:
\itemize{
  \item{}{\code{create.pdf == TRUE}}
  \item{}{\code{low.png > 0}}
  \item{}{\code{high.png > 0}}
}
}
\details{
In order to ensure independence of the operating system, there are strong restrictions on the name of the file. It
can consist of the following symbols only: Latin letters, digits, dot (\code{.}), dash (\code{-}) and underline
(\code{_}). The name must not include paths, that is, slash (\code{/}) or backslash (\code{\\}) cannot be used.
}
\examples{
\donttest{
plot.image <- createReportPlot('scatterplot_tumors')
plot(x = c(0.4, 1), y = c(9, 3), type = 'p', main = NA, xlab = expression(beta), ylab = 'Measure')
off(plot.image)
}

}
\seealso{
\code{\link{pdf}} for manually initializing a graphics device; \code{\linkS4class{Report}} for other
  functions adding contents to an HTML report
}
\author{
Yassen Assenov
}
