% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Report-methods.R
\name{createReport}
\alias{createReport}
\title{createReport}
\usage{
createReport(
  fname,
  title,
  page.title = "RnBeads report",
  authors = NULL,
  dirs = NULL,
  init.configuration = FALSE
)
}
\arguments{
\item{fname}{Single-element \code{character} vector denoting the name of the file to contain the HTML
report. If this file already exists, it will be overwritten.}

\item{title}{Title of the report in the form of a single-element \code{character} vector.}

\item{page.title}{Web page title. This usually appears in the web browser's window title when the report is
open. If specified, this must be a vector. Note that only the first element is used.}

\item{authors}{Optional list of authors in the form of a \code{character} vector. This list is included in
the header of the generated HTML file. Note that author names can contain only Latin leters,
space, dash (\code{-}), comma (\code{,}) or dot (\code{.}).}

\item{dirs}{Location of the supporting directories, that is, paths that are expected to contain
additional files linked to from the HTML report. See the \emph{Details} section for a list
of these directories.}

\item{init.configuration}{Flag indicating if the report configuration data should be initialized. If this parameter
is \code{TRUE}, the method creates the respective directory and copies configuration files
that define cascading style sheet (CSS) definitions and Javascript functions used by the
HTML report. If such configuration files already exist, they will be overwritten. Since the
aforementioned files can be shared by multiple reports, it is recommended that the
configuration is initialized using the method \code{\link{rnb.initialize.reports}}, instead
of setting this flag to \code{TRUE}.}
}
\value{
Newly created \code{\linkS4class{Report}} object.
}
\description{
Creates a new report object.
}
\details{
If specified, the parameter \code{dirs} must be a \code{character} vector. The following names are read:
\itemize{
 \item{\code{"configuration" }}{Directory that contains the auxilliary configuration files, such as style sheets and
       Javascript files. If missing or \code{NA}, the default value used is \code{"configuration"}.}
 \item{\code{"data" }}{Directory to contain the tables, lists and other generated data files that are linked to in
       the HTML report. If missing or \code{NA}, the value used is formed from the file name \code{fname} (without
       the extension) and the suffix \code{"_data"}.}
 \item{\code{"pngs" }}{Directory to contain the low resolution PNG images shown in the HTML report. If missing or
       \code{NA}, the value used is formed from the file name \code{fname} (without the extension) and the suffix
       \code{"_images"}.}
 \item{\code{"pdfs" }}{Directory to contain the PDF images (if such are created). If not missing or \code{NA}, the
       value used is formed from the file name \code{fname} (without the extension) and the suffix \code{"_pdf"}.}
 \item{\code{"high" }}{Directory to contain the high resolution PNG images (if such are created). If missing or
       \code{NA}, the value used is the same as the \code{pngs} directory.}
}
Any other elements, if present, are ignored. Note that these directories are not required to point to different
locations. In particular, if the directories for low and for high resolution images are identical, the
high-resolution image files are assumed to be the ones with suffix \code{"_high_resolution.png"}. See
\code{\link{createReportPlot}} for creating image files.
In order to ensure independence of the operating system, there are strong restrictions on the names of the file and
directories. The name of the report's HTML file can consist of the following symbols only: Latin letters, digits, dot
(\code{.}), dash (\code{-}) and underline (\code{_}). The extension of the report's HTML file must be one of
\code{htm}, \code{html}, \code{xhtml} or \code{xml}. The supporting directories must be given as relative paths;
the restrictions on the path names are identical to the ones for file name. Forward slash (\code{/}) is to be used as
path separator. Path names cannot start or end with a slash. None of the directory names can be
an empty string, use \code{"."} instead. A value in the form \code{"mypath/.html"} for \code{fname} is invalid.
Upon initialization, the report attempts to create or overwrite the specified \code{fname}. If the path to it does
not exist, or if the current process does not have permissions to write to the file, report initialization will fail.
The report object visits each supporting directory (except \code{configuration}) and attempts to create it, unless it
is an existing empty directory. Report initialization will fail if any of the visited directories does not meet the
criteria and could not be created. Hidden files (file names starting with \code{"."} on Unix platforms) are ignored.
Thus, all supporting directories that already exist and contain hidden files only are considered valid.
}
\examples{
\donttest{
report <- createReport("example.html", "Example", init.configuration = TRUE)
}
}
\seealso{
\code{\linkS4class{Report}} for functions adding contents to an HTML report
}
\author{
Yassen Assenov
}
