% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBSet-class.R
\docType{methods}
\name{annotation,RnBSet-method}
\alias{annotation,RnBSet-method}
\alias{annotation}
\title{annotation-methods}
\usage{
\S4method{annotation}{RnBSet}(object, type = "sites", add.names = FALSE, include.regions = FALSE)
}
\arguments{
\item{object}{dataset as an object of type inheriting \code{RnBSet}.}

\item{type}{loci or regions for which the annotation should be obtained. If the value of this parameter is
\code{"sites"} (default), individual methylation sites are annotated. Otherwise, this must be one of
the available region types, as returned by \code{\link{rnb.region.types}}.}

\item{add.names}{flag specifying whether the unique site identifiers should be used as row names of the
resulting data frame}

\item{include.regions}{if \code{TRUE} one additional column is added to the returned annotation dat frame
for each of the available region types, giving the indices of the}
}
\value{
Annotation table in the form of a \code{data.frame}.
}
\description{
Genomic annotation of the methylation sites or regions covered in the supplied dataset.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
## show present sites
head(annotation(rnb.set.example, add.names=TRUE))
## show promoters
ann.prom<-annotation(rnb.set.example, type="promoters", add.names=TRUE)
head(ann.prom)
}
}
\author{
Pavlo Lutsik
}
