% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBSet-class.R
\docType{methods}
\name{addPheno,RnBSet-method}
\alias{addPheno,RnBSet-method}
\alias{addPheno}
\title{addPheno}
\usage{
\S4method{addPheno}{RnBSet}(object, trait, header)
}
\arguments{
\item{object}{\code{\linkS4class{RnBSet}} of interest.}

\item{trait}{Trait as a non-empty \code{vector} or \code{factor}. The length of this vector must be equal to the
number of samples in \code{object}, the i-th element storing the value for the i-th sample. Note that
names, if present, are ignored.}

\item{header}{Trait name given as a one-element \code{character}. This is the heading to be used for the sample
annotation table. This method fails if such a trait already exists; in other words, if
\code{header \%in\% names(pheno(object))}.}
}
\value{
The modified dataset as an object of type \code{\linkS4class{RnBSet}}.
}
\description{
Adds phenotypic or processing information to the sample annotation table of the given \code{RnBSet} object.
}
\examples{
\donttest{
library(RnBeads.hg19)
data(small.example.object)
logger.start(fname=NA)
is.hiPSC <- pheno(rnb.set.example)[, "Sample_Group"]=="hiPSC"
rnb.set.mod <- addPheno(rnb.set.example, is.hiPSC, "is_hiPSC")
pheno(rnb.set.mod)
}
}
\author{
Fabian Mueller
}
