% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\docType{data}
\name{RnBeads.data}
\alias{RnBeads.data}
\title{RnBeads Annotation Tables}
\format{
\code{list} of four elements - \code{"regions"}, \code{"sites"}, \code{"controls"} and \code{"mappings"}.
        These elements are described below.
        \describe{
          \item{\code{"regions"}}{\code{list} of \code{NULL}s; the names of the elements correspond to the built-in
               region annotation tables. Once the default annotations are loaded, the attribute \code{"builtin"} is
               a \code{logical} vector storing, for each region annotation, whether it is the default (built-in) or
               custom.}
          \item{\code{"sites"}}{\code{list} of \code{NULL}s; the names of the elements correspond to the site and
               probe annotation tables.}
          \item{\code{"controls"}}{\code{list} of \code{NULL}s; the names of the elements correspond to the control
               probe annotation tables. The attribute \code{"sites"} is a \code{character} vector pointing to the
               site annotation that encompasses the respective control probes.}
          \item{\code{"mappings"}}{\code{list} of \code{NULL}s; the names of the elements correspond to the built-in
               region annotation tables.}
        }
}
\description{
RnBeads uses sets of annotation tables and mappings (from regions to sites) for each of the supported genomes. The
structures for one assembly are stored in a separate dedicated annotation package. The following annotation packages
are available in Bioconductor:
\describe{
	 \item{\pkg{RnBeads.hg38}}{for \code{"hg38"}}
  \item{\pkg{RnBeads.hg19}}{for \code{"hg19"}}
  \item{\pkg{RnBeads.mm10}}{for \code{"mm10"}}
  \item{\pkg{RnBeads.mm9}}{for \code{"mm9"}}
  \item{\pkg{RnBeads.rn5}}{for \code{"rn5"}}
}
}
\details{
An assembly-specific scaffold is automatically loaded upon initialization of its annotation, that is, by the first
valid call to any of the following functions: \code{\link{rnb.get.chromosomes}},
\code{\link{rnb.get.annotation}}, \code{\link{rnb.set.annotation}}, \code{\link{rnb.get.mapping}},
\code{\link{rnb.annotation.size}}. Adding an annotation amounts to attaching its table(s) and mapping structures to
the scaffold.
}
\author{
Yassen Assenov
}
\keyword{datasets}
