% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RnBeadRawSet-class.R
\docType{class}
\name{RnBeadRawSet-class}
\alias{RnBeadRawSet-class}
\alias{RnBeadRawSet}
\alias{initialize,RnBeadRawSet-method}
\title{RnBeadRawSet-class}
\usage{
RnBeadRawSet(
  pheno,
  probes,
  M,
  U,
  M0 = NULL,
  U0 = NULL,
  bead.counts.M = NULL,
  bead.counts.U = NULL,
  p.values = NULL,
  qc = NULL,
  platform = "450k",
  beta.offset = 100,
  summarize.bead.counts = TRUE,
  summarize.regions = TRUE,
  region.types = rnb.region.types.for.analysis(ifelse(platform == "MMBC", "mm10",
    ifelse(target == "probesEPICv2", "hg38", rnb.getOption("assembly")))),
  useff = rnb.getOption("disk.dump.big.matrices"),
  ffcleanup = FALSE
)
}
\arguments{
\item{pheno}{Phenotypic data.}

\item{probes}{\code{character} vector of Infinium(R) probe identifiers}

\item{M}{Matrix of intensities for the probes measuring the abundance of methylated molecules}

\item{U}{Matrix of intensities for the probes measuring the abundance of unmethylated molecules}

\item{M0}{Matrix of "out-of-band" intensities for the probes measuring the abundance of methylated molecules}

\item{U0}{Matrix of "out-of-band" intensities for the probes measuring the abundance of unmethylated molecules}

\item{bead.counts.M}{Matrix of bead counts per probe.}

\item{bead.counts.U}{Matrix of bead counts per probe.}

\item{p.values}{Matrix of detection p-values.}

\item{qc}{...}

\item{platform}{\code{character} singleton specifying the microarray platform: \code{"450k"} corresponds to HumanMethylation450 microarray, and \code{"27k"} stands for HumanMethylation27.}

\item{beta.offset}{A regularization constant which is added to the denominator at beta-value calculation}

\item{summarize.bead.counts}{If \code{TRUE} the coverage slot is filled by summarizing the \code{bead.counts.M} and \code{bead.counts.U} matrices. For type I probes the summarization is done using \code{min} operation, while for type II probes the bead counts should be identical in both supplied matrices}

\item{summarize.regions}{...}

\item{region.types}{A \code{character} vector specifying the region types, for which the methylation infromation will be summarized.}

\item{useff}{If \code{TRUE} the data matrices will be stored as \code{ff} objects}

\item{ffcleanup}{If \code{TRUE} and disk dumping has been enabled the data of the input \code{ff} objects will be deleted}
}
\value{
an object of class RnBeadRawSet
}
\description{
Main class for storing HumanMethylation micorarray data which includes intensity information
}
\section{Slots}{

\describe{
\item{\code{pheno}}{Phenotypic data.}
\item{\code{M}}{\code{matrix} of intensities for the probes measuring the abundance of methylated molecules.} 
\item{\code{U}}{\code{matrix} of intensities for the probes measuring the abundance of unmethylated molecules.} 
	\item{\code{M0}}{\code{matrix} of "out-of-band" intensities for the probes measuring the abundance of methylated molecules.} 
	\item{\code{U0}}{\code{matrix} of "out-of-band" intensities for the probes measuring the abundance of unmethylated molecules.}
	\item{\code{bead.counts.M}}{\code{matrix} of bead counts per probe.}
	\item{\code{bead.counts.U}}{\code{matrix} of bead counts per probe.}
}
}

\section{Methods and Functions}{

\describe{
  \item{\code{samples}}{Gets the identifiers of all samples in the dataset.}
  \item{\code{\link[=M,RnBeadRawSet-method]{M}}}{Get the matrix of intensities for the probes measuring the abundance of methylated molecules.}
  \item{\code{\link[=U,RnBeadRawSet-method]{U}}}{Get the matrix of intensities for the probes measuring the abundance of unmethylated molecules.}
  \item{\code{\link{intensities.by.color}}}{Get probe intensities in each color channel.}
}
}

\author{
Pavlo Lutsik
}
