% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\docType{class}
\name{RnBeadClustering-class}
\alias{RnBeadClustering-class}
\alias{initialize,RnBeadClustering-method}
\title{RnBeadClustering Class}
\description{
Storage class for the results of a clustering algorithm applied on an \code{\linkS4class{RnBSet}} dataset.
}
\section{Slots}{

\describe{
  \item{dissimilarity}{Dissimilarity metric used in the form of a one-element \code{character} vector.}
  \item{dimensionality}{Dimensionality of the clustered points in the form of a one-element \code{integer} vector.}
  \item{algorithm}{Clustering algorithm (and optionally, type) as a \code{character} vector of length 1 or 2.}
  \item{result}{Resulting object after applying the clustering algorithm on a dataset.}
  \item{assignments}{Cluster assignments for the samples in the dataset as a matrix. Row names in this matrix are
       sample identifiers, and each column is dedicated to partitioning into \emph{k} clusters for a fixed \emph{k}.}
  \item{silhouettes}{\code{numeric} vector of mean silhouette values for each tested value of \emph{k}.}
}
}

\section{Methods and Functions}{

\describe{
  \item{\code{samples}}{Gets the identifiers of all samples used in the clustering.}
}
}

\author{
Yassen Assenov
}
