% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReportPlot-class.R
\docType{class}
\name{ReportPlot-class}
\alias{ReportPlot-class}
\alias{initialize,ReportPlot-method}
\title{ReportPlot Class}
\description{
Information about the files created to store one generated plot in a report. Report plots are initialized using the
function \code{\link{createReportPlot}}.
}
\section{Slots}{

\describe{
  \item{\code{fname}}{Relative file name. It does not include path or extension.}
  \item{\code{width}}{Width of the image in inches.}
  \item{\code{height}}{Height of the image in inches.}
  \item{\code{create.pdf}}{Flag indicating if a PDF image is created.}
  \item{\code{low.png}}{Resolution, in dots per inch, used for the figure image.}
  \item{\code{high.png}}{Resolution, in dots per inch, used for the high-resolution image.}
  \item{\code{dir.pdf}}{Directory that contains the generated PDF file.}
  \item{\code{dir.png.low}}{Directory that contains the generated figure image file.}
  \item{\code{dir.png.high}}{Directory that contains the generated high-resolution image file.}
}
}

\section{Methods and Functions}{

\describe{
  \item{\code{\link{get.files}}}{Gets the list of all files that are planned to be generated,
       or were already generated by the report plot.}
  \item{\code{\link[=off,ReportPlot-method]{off}}}{Copies the figure to a PNG file (if needed) and closes the device
       associated with the report plot.}
}
}

\author{
Yassen Assenov
}
