% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printPCA.R
\name{printPCA}
\alias{printPCA}
\title{Plots the PCA scatterplots produced by codonPCA function.}
\usage{
printPCA(listPCAGraphs)
}
\arguments{
\item{listPCAGraphs}{a list of 5 PCA ggplot scatterplots.}
}
\value{
a unique plot with the 5 PCA scatterplots.
}
\description{
Plots the PCA scatterplots produced by codonPCA function.
}
\examples{
#How to perform a PCA analysis based on codon coverage
data(codonDataCtrl)
codonData <- codonDataCtrl
codonUsage <- codonData[[1]]
codonCovMatrix <- codonData[[2]]

#keep only genes with a minimum number of reads
nbrReadsGene <- apply(codonCovMatrix, 1, sum)
ixExpGenes <- which(nbrReadsGene >= 50)
codonCovMatrix <- codonCovMatrix[ixExpGenes, ]

#get the PCA on the codon coverage
codonCovMatrixTransp <- t(codonCovMatrix)
rownames(codonCovMatrixTransp) <- colnames(codonCovMatrix)
colnames(codonCovMatrixTransp) <- rownames(codonCovMatrix)

listPCACodonCoverage <- codonPCA(codonCovMatrixTransp,"codonCoverage")
printPCA(listPCACodonCoverage[[2]])
}

