% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orfRelativePos.R
\name{orfRelativePos}
\alias{orfRelativePos}
\title{Relative position of the start and stop codon along the transcript}
\usage{
orfRelativePos(cdsTransc, exonGRanges)
}
\arguments{
\item{cdsTransc}{a GRangesList.
It contains the CDS coordinates grouped by transcript.}

\item{exonGRanges}{a GRangesList.
It contains the exon coordinates grouped by transcript.}
}
\value{
a list.
A list of relative positions of the start and end of ORFs.
}
\description{
Relative position of the start and stop codon along the transcript
}
\examples{
#make a txdb object containing the annotations for the specified species.
#In this case hg19.
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene

#get all CDSs by transcript
cds <- GenomicFeatures::cdsBy(txdb, by="tx", use.names=TRUE)

#get all exons by transcript
exonGRanges <- GenomicFeatures::exonsBy(txdb, by="tx", use.names=TRUE)

#retrieve the positions of start and end codons relative to the transcript
cdsPosTransc <- orfRelativePos(cds, exonGRanges)
}

