% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codonInfo.R
\name{codonInfo}
\alias{codonInfo}
\title{Associates the read counts on codons with the codon type for each ORF.}
\usage{
codonInfo(listReadsCodon, genomeSeq, orfCoord, motifSize)
}
\arguments{
\item{listReadsCodon}{a list of data.frame objects.
It contains the number of reads per codon in a CDS.}

\item{genomeSeq}{a BSgenome object.
It contains the full genome sequences for the organism.}

\item{orfCoord}{a GRangesList.
The coordinates of the ORFs on the genome.}

\item{motifSize}{an integer. The number of nucleotides in each motif
on which to compute coverage and usage. Either 3, 6, or 9.
Default 3 nucleotides (codon).
Attention! For long motifs, the function can be quite slow!!}
}
\value{
a list of 2 data.frame objects:
one with the number of times each codon type is found in each ORF and
one with the number of reads for each codon type in each ORF.
}
\description{
Associates the read counts on codons with the codon type for each ORF.
}
\examples{
#for each codon in each ORF get the read coverage
#parameter listReadsCodon can be returned by the riboSeqFromBam function
#it corresponts to the 2nd element in the list returned by riboSeqFromBam
data(codonIndexCovCtrl)
listReadsCodon <- codonIndexCovCtrl

txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene

#get the names of the ORFs
#grouped by transcript
cds <- GenomicFeatures::cdsBy(txdb, use.names=TRUE)
orfCoord <- cds[names(cds) \%in\% names(listReadsCodon)]

#get the genome, please check that the genome has the same seqlevels
genomeSeq <- BSgenome.Hsapiens.UCSC.hg19::BSgenome.Hsapiens.UCSC.hg19
#if not rename it
#seqlevels(gSeq) <- sub("chr", "", seqlevels(genomeSeq))

#codon frequency, coverage, and annotation
codonData <- codonInfo(listReadsCodon, genomeSeq, orfCoord)
}
