% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_helpers.R
\name{collection_path_from_exp}
\alias{collection_path_from_exp}
\title{Get collection path}
\usage{
collection_path_from_exp(
  df,
  id,
  gene_name_list = NULL,
  must_exists = TRUE,
  collection_dir = collection_dir_from_exp(df, must_exists),
  grl_all = loadRegion(df)
)
}
\arguments{
\item{df}{ORFik experiment}

\item{id}{character, transcript ids}

\item{gene_name_list}{a data.table, default NULL, with gene ids}

\item{must_exists}{logical, stop if dir does not exists}

\item{collection_dir}{= collection_dir_from_exp(df, must_exists)}

\item{grl_all}{a GRangesList for new format, what genomic range to get.}
}
\value{
file.path(resFolder(df), "collection_tables")
}
\description{
For directory and id, must be fst format file
}
\examples{
df <- ORFik.template.experiment()
tx_id <- "ENST0000012312"
collection_path_from_exp(df, id = tx_id, must_exists = FALSE)
}
