% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomizeTx.R
\name{randomizeTx}
\alias{randomizeTx}
\title{Get randmized regions over transcriptome}
\usage{
randomizeTx(txdb, trans_ids = 'all',
random_num = 100, random_length = 20, type = 'mature', N = 1, ...)
}
\arguments{
\item{txdb}{A TxDb object.}

\item{trans_ids}{The ids of transcripts, which should be a character object. Random regions will be picked from these transcripts. If this argument takes the default value 'all', the scope of picking random regions will be the whole transcriptome.}

\item{random_num}{The number of regions to be picked.}

\item{random_length}{The length of regions to be picked.}

\item{type}{A character object. Default is "mature". It accepts options "mature", "full", "fiveUTR", "CDS" or "threeUTR", with which one can get corresponding types of transcriptome regions.}

\item{N}{Randomization times.}

\item{...}{Any additional parameters needed.}
}
\value{
A \code{GRangesList} object. The name of each element is the id of the transcript where the corresponding range is located.
}
\description{
Pick random regions over specified transcripts.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
trans.ids <- c("170", "782", "974", "1364", "1387")
RS1 <- randomizeTx(txdb, trans.ids, random_num = 100, random_length = 100)
}
\seealso{
\code{\link{randomizeTransByOrder}}, \code{\link{randomizeFeaturesTx}}, \code{\link{randomizeFeaturesTxIA}}
}
