% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomizeTransByOrder.R
\name{randomizeTransByOrder}
\alias{randomizeTransByOrder}
\title{Randomize features into transcriptome}
\usage{
randomizeTransByOrder(regions_A, random_length = 20)
}
\arguments{
\item{regions_A}{A \code{GRangesList} object. The name of each list element should be the corresponding transcript id.}

\item{random_length}{A \code{numeric} object.}
}
\value{
A \code{GRangesList} object. The name of each list element should be the corresponding transcript id.
}
\description{
This function receives a \code{GRangesList} object and picks a random region within each list element of this object. The length of the region to be picked is decided by the input \code{random_length} argument.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
exons.tx0 <- exonsBy(txdb)
trans.ids <- sample(names(exons.tx0), 500)
regions.A <- exons.tx0[trans.ids]
RS <- randomizeTransByOrder(regions.A, random_length = 20)
}
\seealso{
\code{\link{randomizeTx}}, \code{\link{randomizeFeaturesTx}}, \code{\link{randomizeFeaturesTxIA}}
}
