% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permTestTx_customPick.R
\name{permTestTx_customPick}
\alias{permTestTx_customPick}
\title{Perform permutation test}
\usage{
permTestTx_customPick(RS1 = NULL, txdb = NULL, type = "mature",
customPick_function = NULL, ntimes = 50, ev_function_1 = overlapCountsTx,
ev_function_2 = overlapCountsTx,  pval_z = FALSE, ...)
}
\arguments{
\item{RS1}{The feature set to be randomized. It should be in the \code{GRanges} or \code{GRangesList} format.}

\item{txdb}{A TxDb object.}

\item{type}{A character object. Default is "mature". It accepts options "mature", "full", "fiveUTR", "CDS" or "threeUTR", with which one can get corresponding types of transcriptome regions.}

\item{customPick_function}{A custom function needs to be inputted by users. The custom function should have two arguments: a TxDb object and a character object of transcript ids. It returns a part of region of each transcript.}

\item{ntimes}{Randomization times.}

\item{ev_function_1}{Evaluation function defines what statistic to be tested between \code{RS1} and \code{RS2}. Default is \code{overlapCountsTx}.}

\item{ev_function_2}{Evaluation function defines what statistic to be tested between each element in \code{RSL} and \code{RS2}. Default is \code{overlapCountsTx}.}

\item{pval_z}{Boolean. Default is FALSE. If FALSE, the p-value is calculated based on the number of random evaluations is larger or less than the initial evaluation. If TRUE, the p-value is calculated based on a z-test.}

\item{...}{Any additional parameters needed.}
}
\value{
A list object, which is defined to be \code{permTestTx.results} class. It contains the following items:
\itemize{
\item \bold{\code{RSL:}} Randomized region sets of \code{RS1}.
\item \bold{\code{RS1:}} The feature set to be randomized.
\item \bold{\code{RS2:}} The region set to be compared with the feature set.
\item \bold{\code{orig.ev:}} The value of overlapping counts between \code{RS1} and \code{RS2}.
\item \bold{\code{rand.ev:}} The values of overlapping counts between each element in \code{RSL} and \code{RS2}.
\item \bold{\code{pval:}} p-value of the test.
\item \bold{\code{zscore:}} Standard score of the test.
}
}
\description{
Perform permutation test for evaluating spatial association between a feature set and the customPick regions. The latter is defined by the \code{customPick_function} argument provided by users.
}
\details{
Each feature in \code{RS1} is only mapped with the customPick regions over its transcript (picked by the \code{customPick_function}). The output \code{orig.ev} is the number of features that have overlap with its customPick region.
The set of randomized region sets is outputted as \code{RSL}. The overlapping counts between each set in \code{RSL} with \code{RS2} is outputted as \code{rand.ev}.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
exons.tx0 <- exonsBy(txdb)
trans.ids <- sample(names(exons.tx0), 100)
RS1 <- randomizeTx(txdb, trans.ids, random_num = 100,
random_length = 200, type = 'CDS')
getCDS = function(txdb, trans.id){
cds.tx0 <- cdsBy(txdb, use.names=FALSE)
    cds.names <- as.character(intersect(names(cds.tx0), trans.id))
    cds = cds.tx0[cds.names]
    return(cds)
}

permTestTx_results <- permTestTx_customPick(RS1,txdb,
customPick_function = getCDS, ntimes = 5)
}
\seealso{
\code{\link{plotPermResults}}
}
