% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlapCountsTxIA.R
\name{overlapCountsTxIA}
\alias{overlapCountsTxIA}
\title{Evaluation function}
\usage{
overlapCountsTxIA(A, B, ...)
}
\arguments{
\item{A}{A feature set, which should be \code{GRanges}.}

\item{B}{A region set, which should be \code{GRangesList}.}

\item{...}{Any additional parameters needed.}
}
\value{
A \code{numeric} object.
}
\description{
Evaluation function. This function receives a feature set (with isoform ambiguity) and a transcriptome region set (without isoform ambiguity), and returns a weighted number of overlaps between them.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
file <- system.file(package="RgnTX", "extdata/m6A_sites_data.rds")
m6A_sites_data <- readRDS(file)
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
RS1 <- m6A_sites_data[1:100]

trans.info <- getTransInfo(RS1, txdb)
trans.ids <- trans.info[, "trans_ID"]

RS2 <- getStopCodon(trans.ids, txdb = txdb)

# Evaluation step.
orig.ev <- overlapCountsTxIA(RS1, RS2)
}
\seealso{
\code{\link{overlapWidthTx}}, \code{\link{distanceTx}}, \code{\link{overlapCountsTx}}
}
