% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPermSpaceByType.R
\name{getPermSpaceByType}
\alias{getPermSpaceByType}
\title{Get permutation space by specifying type}
\usage{
getPermSpaceByType(txdb, type = "mature")
}
\arguments{
\item{txdb}{A TxDb object.}

\item{type}{A character object. Default is "mature". It accepts options "mature", "full", "fiveUTR", "CDS" or "threeUTR", with which one can get corresponding types of transcriptome regions.}
}
\value{
A \code{GRangesList} object.
}
\description{
This function can return 5'UTR/CDS/3'UTR/mRNA/full part of transcriptome regions, following the format required by the main permutation test functions.
}
\examples{
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg19.knownGene
permSpace <- getPermSpaceByType(txdb, type = "CDS")
}
\seealso{
\code{\link{getPermSpaceByTxID}}, \code{\link{getPermSpaceByFeatures}}
}
