% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetCrossRegionalDE_raw.R
\name{GetCrossRegionalDE_raw}
\alias{GetCrossRegionalDE_raw}
\title{Identify cross-regional differential analysis}
\usage{
GetCrossRegionalDE_raw(
  sce,
  twoCenter = c(3, 4),
  enhanced = FALSE,
  label = "celltype",
  n_markers = 10,
  logfc.threshold = 0.25,
  angle = 30,
  hjust = 0,
  size = 3,
  min.pct = 0.1,
  padj_filter = 0.05,
  doHeatmap = TRUE
)
}
\arguments{
\item{sce}{A single cell experiment object.}

\item{twoCenter}{A vector of two numbers for the interested ROI numbers.}

\item{enhanced}{A logical variable for using enhanced data or not.}

\item{label}{A variable name that contains the cell type information.}

\item{n_markers}{A number specifying the top DE gene number.}

\item{logfc.threshold}{A number for the cutoff threshold of log fold change.}

\item{angle}{A number for angle when plotting.}

\item{hjust}{A number for horizontal justification when plotting.}

\item{size}{A number for text font size.}

\item{min.pct}{A number of minimum percentage specified in the Seurat DE function.}

\item{padj_filter}{A number for filtering adjusted p values.}

\item{doHeatmap}{Logical variable for whether drawing the heatmap.}
}
\value{
A list including the top DE genes (topDE), and all DE genes (allDE).
}
\description{
Identify cross-regional differential analysis
}
\examples{
data("example_sce")
example_sce <- mySpatialPreprocess(example_sce, platform="Visium")
# I used a very big padj filter here because this is just a toy data
GetCrossRegionalDE_raw(example_sce, twoCenter = c(1,2),
                       min.pct = 0.01, logfc.threshold = 0.01,
                       padj_filter = 0.5)

}
