% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regenrich_diffExpr.R
\name{regenrich_diffExpr}
\alias{regenrich_diffExpr}
\alias{regenrich_diffExpr,RegenrichSet-method}
\title{Differential expression analysis step}
\usage{
regenrich_diffExpr(object, ...)

\S4method{regenrich_diffExpr}{RegenrichSet}(object, ...)
}
\arguments{
\item{object}{a `RegenrichSet` object, which is initialized by
\code{\link{RegenrichSet}} function.}

\item{...}{arguments for differential analysis.
After constructing a `RegenrichSet` object,
all arguments for RegEnrich analysis have been initialized and
stored in `paramsIn`` slot. while the arguments for differential analysis
can be re-specified here.\cr\cr
These arguments include 'method', 'minMeanExpr', 'design', 'reduced',
'contrast',
'coef', 'name', 'fitType', 'sfType', 'betaPrior', 'minReplicatesForReplace',
'useT', 'minmu', 'parallel', 'BPPARAM', 'altHypothesis',
'listValues', 'cooksCutoff', 'independentFiltering', 'alpha',
'filter', 'theta', 'filterFun', 'addMLE', 'blind', 'ndups',
'spacing', 'block', 'correlation', 'weights', 'proportion',
'stdev.coef.lim', 'trend', 'robust', and 'winsor.tail.p'.\cr
See \code{\link{RegenrichSet}} function for more details about these
arguments.}
}
\value{
This function returns a `RegenrichSet` object with an updated
`resDEA` slot, which is a `DeaSet` object, and an updated `paramsIn` slot.
See \code{\link{newDeaSet}} function for more details about `DeaSet` class.
If an argument not in the above list is specified in the regenrich_diffExpr
function, a warning or error will be raised.
}
\description{
This is the first step of RegEnrich analysis.
differential expression analysis by this function needs to
be performed on a `RegenrichSet` object.
}
\examples{
# library(RegEnrich)
data("Lyme_GSE63085")
data("TFs")

data = log2(Lyme_GSE63085$FPKM + 1)
colData = Lyme_GSE63085$sampleInfo

# Take first 2000 rows for example
data1 = data[seq(2000), ]

design = model.matrix(~0 + patientID + week, data = colData)

# Initializing a 'RegenrichSet' object
object = RegenrichSet(expr = data1,
                      colData = colData,
                      method = 'limma', minMeanExpr = 0,
                      design = design,
                      contrast = c(rep(0, ncol(design) - 1), 1),
                      networkConstruction = 'COEN',
                      enrichTest = 'FET')
# Using the predifined parameters in the previous step
(object = regenrich_diffExpr(object))

# re-specifying parameter 'minMeanExpr'
print(slot(object, 'paramsIn')$minMeanExpr)
(object = regenrich_diffExpr(object, minMeanExpr = 1))
print(slot(object, 'paramsIn')$minMeanExpr)

# Unrecognized argument 'unrecognizedArg' (Error)
# object = regenrich_diffExpr(object, minMeanExpr = 1,
#                             unrecognizedArg = 23)

# Argument not for differential expression analysis (Warning)
# print(slot(object, 'paramsIn')$networkConstruction)
# (object = regenrich_diffExpr(object, minMeanExpr = 1,
#                              networkConstruction = 'GRN'))
# print(slot(object, 'paramsIn')$networkConstruction) # not changed
}
\seealso{
Initialization of a `RegenrichSet` object
\code{\link{RegenrichSet}},and next step
\code{\link{regenrich_network}}.
}
