% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regenrichClasses.R
\name{newDeaSet}
\alias{newDeaSet}
\title{DeaSet object creator}
\usage{
newDeaSet(
  assayRaw = matrix(nrow = 0, ncol = 0),
  rowData = NULL,
  assays = SimpleList(),
  colData = DataFrame(),
  metadata = list()
)
}
\arguments{
\item{assayRaw}{A matrix of gene expression data. This can be the same
as the matrix-like element in \code{assays} parameter.}

\item{rowData}{A DataFrame object describing the rows.}

\item{assays}{A list or SimpleList of matrix-like element, 
or a matrix-like object. The matrix-like element can be the same
as \code{assayRaw} parameter.}

\item{colData}{A DataFrame describing the sample information.}

\item{metadata}{An optional list of arbitrary content describing the
overall experiment.}
}
\value{
A DeaSet object.
}
\description{
DeaSet object creator
}
\examples{
# Empty DeaSet object
newDeaSet()

# 100 * 6 DeaSet object
nrows = 100
ncols = 6
counts = matrix(rnbinom(nrows * ncols, size = 2, mu = 500),
                nrow = nrows)
assays = SimpleList(counts=counts)

colData = DataFrame(Condition = rep(c("treatment", "ctrl"), 3),
                    row.names=LETTERS[1:6])
geneNames = sprintf("G\%03s", seq(nrows))
elementMetadata = DataFrame(gene = geneNames,
                            p = numeric(nrows),
                            logFC = numeric(nrows))
newDeaSet(assayRaw = counts, 
          rowData = elementMetadata,
          assays = SimpleList(assayData = counts),
          colData = colData)
}
