% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-FactorisedExperiment.R
\name{stability}
\alias{stability}
\alias{stability<-}
\alias{stability,FactorisedExperiment-method}
\alias{stability<-,FactorisedExperiment-method}
\title{Get and setting the stability values for factors}
\usage{
\S4method{stability}{FactorisedExperiment}(object)

\S4method{stability}{FactorisedExperiment}(object) <- value
}
\arguments{
\item{object}{\link[ReducedExperiment]{FactorisedExperiment} object.}

\item{value}{New value to replace existing stability vector.}
}
\value{
A vector with a value for each factor indicating the factor
stability. More details are available from the
\link[ReducedExperiment]{estimateStability} help page.
}
\description{
Get and setting the stability values for factors
}
\examples{
# Get a random matrix with rnorm, with 100 rows (features)
# and 20 columns (observations)
X <- ReducedExperiment:::.makeRandomData(100, 20, "feature", "obs")

# Run stabilised ICA on the data with 5 components
fe <- estimateFactors(X, nc = 5, use_stability = TRUE)

stability(fe)

stability(fe)[2] <- 10
stability(fe)

}
\seealso{
\code{\link[=estimateStability]{estimateStability()}}
}
\author{
Jack Gisby
}
