% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-ReducedExperiment.R
\name{sampleNames}
\alias{sampleNames}
\alias{sampleNames<-}
\alias{sampleNames,ReducedExperiment-method}
\alias{sampleNames<-,ReducedExperiment-method}
\alias{colnames<-,ReducedExperiment-method}
\title{Get sample names}
\usage{
\S4method{sampleNames}{ReducedExperiment}(x)

\S4method{sampleNames}{ReducedExperiment}(x) <- value

\S4method{colnames}{ReducedExperiment}(x) <- value
}
\arguments{
\item{x}{\link[ReducedExperiment]{ReducedExperiment} object.}

\item{value}{New value to replace existing names.}
}
\value{
A vector containing the names of the features.
}
\description{
Retrieves sample names (colnames).
}
\examples{
# Create randomised data with the following dimensions
i <- 300 # Number of features
j <- 100 # Number of samples
k <- 10 # Number of factors

rand_assay_data <- ReducedExperiment:::.makeRandomData(i, j, "gene", "sample")
rand_reduced_data <- ReducedExperiment:::.makeRandomData(j, k, "sample", "component")

re <- ReducedExperiment(
    assays = list("normal" = rand_assay_data),
    reduced = rand_reduced_data
)

stopifnot(all.equal(sampleNames(re), colnames(rand_assay_data)))
stopifnot(all.equal(colnames(re), colnames(rand_assay_data)))

print(paste0("Sample name at [80]: ", sampleNames(re)[80]))
sampleNames(re)[80] <- "custom_feature_name"
print(paste0("Sample data at [80]: ", sampleNames(re)[80]))

}
\author{
Jack Gisby
}
