% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/methods-ReducedExperiment.R
\docType{class}
\name{ReducedExperiment-class}
\alias{ReducedExperiment-class}
\alias{.ReducedExperiment}
\alias{ReducedExperiment}
\title{ReducedExperiment: A container for dimensionally-reduced representations}
\usage{
ReducedExperiment(reduced = new("matrix"), scale = TRUE, center = TRUE, ...)
}
\arguments{
\item{reduced}{A \code{matrix}, usually the result of some type of
dimensionality-reduction, with rows representing samples and columns
representing a new set of features.}

\item{scale}{Either a boolean, representing whether or not the original data
has been scaled to unit variance, or a numeric vector indicating the
standard deviations of the original features (as produced by
\link[base]{scale}.)}

\item{center}{Either a boolean, representing whether or not the original data
has been centered to have a mean of 0, or a numeric vector indicating the
means of the original features (as produced by
\link[base]{scale}.)}

\item{...}{Additional arguments to be passed to
\link[SummarizedExperiment]{SummarizedExperiment}.}
}
\value{
Constructor method returns a
\link[ReducedExperiment]{ReducedExperiment} object.
}
\description{
Inherits from \link[SummarizedExperiment]{SummarizedExperiment}, a
container for one or more matrices with features as rows (e.g., genes) and
columns as samples. Additional information on features and samples are
contained in \link[S4Vectors]{DataFrame} tables. The
\code{ReducedExperiment} extends \link[SummarizedExperiment]{SummarizedExperiment}
by additionally providing access to a "reduced" data matrix, in which rows
represent samples and columns represent a second set of dimensionally-reduced
features.

The methods available for \link[SummarizedExperiment]{SummarizedExperiment}
objects are also available for \code{ReducedExperiment} and its children, which
include \link[ReducedExperiment]{FactorisedExperiment} and
\link[ReducedExperiment]{ModularExperiment}.

Typically, \code{ReducedExperiment} objects contain two main assays. The first is,
by default, named "normal" and contains some type of normalised assay data,
such as gene expression. The second is "transformed", which is typically
the result of applying scaling and/or centering to the normalised data
matrix.
}
\examples{
# Create randomised data with the following dimensions
i <- 300 # Number of features
j <- 100 # Number of samples
k <- 10 # Number of factors

# In this case we use random assay and reduced data, but in
# practice these will likely be the result of applying some kind of
# dimensionality-reduction method to the assay data (e.g., gene
# expression data) from some study.
rand_assay_data <- ReducedExperiment:::.makeRandomData(i, j, "gene", "sample")
rand_reduced_data <- ReducedExperiment:::.makeRandomData(j, k, "sample", "component")

re <- ReducedExperiment(
    assays = list("normal" = rand_assay_data),
    reduced = rand_reduced_data
)

re

}
\seealso{
\code{\link[=FactorisedExperiment]{FactorisedExperiment()}},
\code{\link[=ModularExperiment]{ModularExperiment()}}
}
\author{
Jack Gisby
}
