% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-ModularExperiment.R
\name{plotDendro}
\alias{plotDendro}
\alias{plotDendro,ModularExperiment-method}
\title{Plot a dendrogram stored in a ModularExperiment}
\usage{
\S4method{plotDendro}{ModularExperiment}(
  object,
  groupLabels = "Module colors",
  dendroLabels = FALSE,
  hang = 0.03,
  addGuide = TRUE,
  guideHang = 0.05,
  color_func = WGCNA::labels2colors,
  modules_are_colors = FALSE,
  ...
)
}
\arguments{
\item{object}{\link[ReducedExperiment]{ModularExperiment} object.}

\item{groupLabels}{Module label axis label. See
\link[WGCNA]{plotDendroAndColors}.}

\item{dendroLabels}{If \code{TRUE}, shows feature names in the dendrogram. See
\link[WGCNA]{plotDendroAndColors}.}

\item{hang}{The fraction of the plot height by which labels should hang
below the rest of the plot. See \link[stats]{plot.hclust}.}

\item{addGuide}{If \code{TRUE}, adds vertical guide lines to the dendrogram. See
\link[WGCNA]{plotDendroAndColors}.}

\item{guideHang}{The fraction of the dendrogram's height to leave between
the top end of the guide line and the dendrogram merge height. See
\link[WGCNA]{plotDendroAndColors}.}

\item{color_func}{Function for converting module names to colors. Only used
if \code{modules_are_colors} is \code{FALSE}.}

\item{modules_are_colors}{If \code{TRUE}, expects the module names to be colors.
Else, assumes that module names are are numbers that can be converted into
colours by \code{color_func}.}

\item{...}{Additional arguments to be passed to
\link[WGCNA]{plotDendroAndColors}.}
}
\value{
A plot produced by \link[WGCNA]{plotDendroAndColors}.
}
\description{
Plots the dendrogram in the \code{dendrogam} slot of a
\link[ReducedExperiment]{ModularExperiment} object using the
\link[WGCNA]{plotDendroAndColors} function.
}
\examples{
# Create ModularExperiment with random data (100 features, 50 samples,
# 10 modules)
me <- ReducedExperiment:::.createRandomisedModularExperiment(100, 50, 10)
me

# The dendrogram is usually produced during module discovery, but we can
# assign any dendrogram to the slot. Let's do hierarchical clustering on the
# features in our object and assign it
dendrogram(me) <- hclust(dist(assay(me)))
dendrogram(me)

# Plot the dendrogram - modules are random in this instance, but in general
# features within a module should cluster together
plotDendro(me)

}
\seealso{
\code{\link[WGCNA:plotDendroAndColors]{WGCNA::plotDendroAndColors()}}, \link[stats]{plot.hclust}
}
\author{
Jack Gisby
}
