% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features.R
\name{plotCommonFeatures}
\alias{plotCommonFeatures}
\title{Heatmap comparing commonality across factors}
\usage{
plotCommonFeatures(
  common_features,
  filename = NA,
  color = (grDevices::colorRampPalette(RColorBrewer::brewer.pal(n = 7, name =
    "YlOrRd")))(100)
)
}
\arguments{
\item{common_features}{The output of
\link[ReducedExperiment]{getCommonFeatures}.}

\item{filename}{The path at which to save the plot.}

\item{color}{The colour palette to be used in the heatmap.}
}
\value{
An object generated by \link[pheatmap]{pheatmap}.
}
\description{
Heatmap comparing commonality across factors
}
\examples{
# Get a random matrix with rnorm, with 100 rows (features)
# and 20 columns (observations)
X <- ReducedExperiment:::.makeRandomData(100, 20, "feature", "obs")

# Estimate 5 factors based on the data matrix
fe <- estimateFactors(X, nc = 5)

# Get the genes highly aligned with each factor
aligned_features <- getAlignedFeatures(
    fe,
    format = "data.frame",
    proportional_threshold = 0.3
)

# Identify overlap between common features for each factor
common_features <- getCommonFeatures(aligned_features)

# Plot the common features as a heatmap
plotCommonFeatures(common_features)

}
\seealso{
\code{\link[=getCommonFeatures]{getCommonFeatures()}},
\code{\link[=getAlignedFeatures]{getAlignedFeatures()}}
}
\author{
Jack Gisby
}
