% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/methods-ModularExperiment.R
\docType{class}
\name{ModularExperiment-class}
\alias{ModularExperiment-class}
\alias{.ModularExperiment}
\alias{ModularExperiment}
\title{ModularExperiment: A container for the results of module analysis}
\usage{
ModularExperiment(
  reduced = new("matrix"),
  scale = TRUE,
  center = TRUE,
  loadings = NULL,
  assignments = character(),
  dendrogram = NULL,
  threshold = NULL,
  ...
)
}
\arguments{
\item{reduced}{A \code{matrix}, produced by module analysis, with rows
representing samples and columns representing module expression profiles.
Typically, this matrix contains "eigengenes" produced by the Weighted Gene
Correlation Network Analysis (WGCNA) approach, as is applied by
\link[ReducedExperiment]{identifyModules}.}

\item{scale}{Either a boolean, representing whether or not the original data
has been scaled to unit variance, or a numeric vector indicating the
standard deviations of the original features (as produced by
\link[base]{scale}.)}

\item{center}{Either a boolean, representing whether or not the original data
has been centered to have a mean of 0, or a numeric vector indicating the
means of the original features (as produced by
\link[base]{scale}.)}

\item{loadings}{A numeric vector representing the loadings used to generate
module expression profiles. Typically, these values are obtained from the
rotation matrix produced by \link[stats]{prcomp}, which is used to identify
the first principal component of each module. The vector names represent
features.}

\item{assignments}{A vector of features, named according to the module to
which the feature belongs.}

\item{dendrogram}{Either \code{NULL}, or the dendrogram used to identify modules
from the original data.}

\item{threshold}{Either \code{NULL}, or a matrix produced by
\link[WGCNA]{pickSoftThreshold} indicating the parameters used for network
construction.}

\item{...}{Additional arguments to be passed to
\link[ReducedExperiment]{ReducedExperiment}.}
}
\value{
Constructor method returns a
\code{ModularExperiment} object.
}
\description{
A container inheriting from the \link[ReducedExperiment]{ReducedExperiment}
class, that contains one or more data matrices, to which module analysis
has been applied to identify a reduced set of features.  A
\link[ReducedExperiment]{ModularExperiment} can be created directly in
a similar manner to a \link[SummarizedExperiment]{SummarizedExperiment}.
Alternatively, the \link[ReducedExperiment]{identifyModules} function
can be used to both define modules and generate a
\link[ReducedExperiment]{ModularExperiment} from the results.
}
\examples{
# Create randomised data with the following dimensions
i <- 300 # Number of features
j <- 100 # Number of samples
k <- 10 # Number of modules

# In this case we use random assay data and reduced data (i.e., module
# eigengenes). We also randomly assign each feature to a module. In practice,
# we would identify modules and eigengenes using a method like WGCNA applied
# to the analysis of assay data (e.g., gene expression data) from some study.
rand_assay_data <- ReducedExperiment:::.makeRandomData(i, j, "gene", "sample")
rand_reduced_data <- ReducedExperiment:::.makeRandomData(j, k, "sample", "module")
rand_assignments <- paste0("gene_", seq_len(i))
names(rand_assignments) <- paste0("module_", round(stats::runif(i, 1, k), 0))

me <- ModularExperiment(
    assays = list("normal" = rand_assay_data),
    reduced = rand_reduced_data,
    assignments = rand_assignments
)

me

}
\seealso{
\code{\link[=ReducedExperiment]{ReducedExperiment()}},
\code{\link[=FactorisedExperiment]{FactorisedExperiment()}},
\code{\link[=identifyModules]{identifyModules()}}
}
\author{
Jack Gisby
}
