% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-FactorisedExperiment.R,
%   R/methods-ModularExperiment.R, R/methods-ReducedExperiment.R
\name{names<-,FactorisedExperiment-method}
\alias{names<-,FactorisedExperiment-method}
\alias{featureNames<-,FactorisedExperiment-method}
\alias{rownames<-,FactorisedExperiment-method}
\alias{names<-,ModularExperiment-method}
\alias{featureNames<-,ModularExperiment-method}
\alias{rownames<-,ModularExperiment-method}
\alias{featureNames}
\alias{featureNames<-}
\alias{featureNames,ReducedExperiment-method}
\alias{names<-,ReducedExperiment-method}
\alias{rownames<-,ReducedExperiment-method}
\alias{ROWNAMES<-,ReducedExperiment-method}
\alias{featureNames<-,ReducedExperiment-method}
\title{Get feature names}
\usage{
\S4method{names}{FactorisedExperiment}(x) <- value

\S4method{featureNames}{FactorisedExperiment}(x) <- value

\S4method{rownames}{FactorisedExperiment}(x) <- value

\S4method{names}{ModularExperiment}(x) <- value

\S4method{featureNames}{ModularExperiment}(x) <- value

\S4method{rownames}{ModularExperiment}(x) <- value

\S4method{featureNames}{ReducedExperiment}(x)

\S4method{names}{ReducedExperiment}(x) <- value

\S4method{rownames}{ReducedExperiment}(x) <- value

\S4method{ROWNAMES}{ReducedExperiment}(x) <- value

\S4method{featureNames}{ReducedExperiment}(x) <- value
}
\arguments{
\item{x}{\link[ReducedExperiment]{ReducedExperiment} object.}

\item{value}{New value to replace existing names.}
}
\value{
A vector containing the names of the features.
}
\description{
Gets and sets feature names (i.e., rownames, usually genes).
}
\examples{
# Create randomised data with the following dimensions
i <- 300 # Number of features
j <- 100 # Number of samples
k <- 10 # Number of factors

rand_assay_data <- ReducedExperiment:::.makeRandomData(i, j, "gene", "sample")
rand_reduced_data <- ReducedExperiment:::.makeRandomData(j, k, "sample", "component")

re <- ReducedExperiment(
    assays = list("normal" = rand_assay_data),
    reduced = rand_reduced_data
)

# Methods return equivalent results
stopifnot(all.equal(featureNames(re), rownames(rand_assay_data)))
stopifnot(all.equal(rownames(re), rownames(rand_assay_data)))
stopifnot(all.equal(names(re), rownames(rand_assay_data)))

# We can change the feature name at a particular position
print(paste0("Feature name at position 55: ", featureNames(re)[55]))
featureNames(re)[55] <- "custom_feature_name"
print(paste0("Reduced data at position 55: ", featureNames(re)[55]))

}
\author{
Jack Gisby
}
