% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factors.R
\name{estimateStability}
\alias{estimateStability}
\title{Estimate stability of factors as a function of the number of components}
\usage{
estimateStability(
  X,
  min_components = 10,
  max_components = 60,
  by = 2,
  n_runs = 30,
  resample = FALSE,
  mean_stability_threshold = NULL,
  center_X = TRUE,
  scale_X = FALSE,
  assay_name = "normal",
  BPPARAM = BiocParallel::SerialParam(),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{X}{Either a \link[SummarizedExperiment]{SummarizedExperiment} object
or a matrix containing data to be subject to ICA. \code{X} should have rows as
features and columns as samples.}

\item{min_components}{The minimum number of components to estimate the
stability for.}

\item{max_components}{The maximum number of components to estimate the
stability for.}

\item{by}{The number by which to increment the numbers of components
tested.}

\item{n_runs}{The number of times to run ICA to estimate factors and quantify
stability. Ignored if \code{use_stability} is \code{FALSE}.}

\item{resample}{If \code{TRUE}, a boostrap approach is used to estimate factors
and quantify stability. Else, random initialisation of ICA is employed.
Ignored if \code{use_stability} is \code{FALSE}.}

\item{mean_stability_threshold}{A threshold for the mean stability of factors.}

\item{center_X}{If \code{TRUE}, X is centered (i.e., features / rows are transformed
to have a mean of 0) prior to ICA. Generally recommended.}

\item{scale_X}{If \code{TRUE}, X is scaled (i.e., features / rows are transformed
to have a standard deviation of 1) before ICA.}

\item{assay_name}{If \code{X} is a
\link[SummarizedExperiment]{SummarizedExperiment}, then this should be the
name of the assay to be subject to ICA.}

\item{BPPARAM}{A class containing parameters for parallel evaluation. Uses
\link[BiocParallel]{SerialParam} by default, running only a single
ICA computation at a time. Ignored if \code{use_stability}
is \code{FALSE}.}

\item{verbose}{If \code{TRUE}, shows a progress bar that updates for each
number of components tested. Note that the time taken may not be linear,
because the time taken to run ICA generally increases with the number
of components.}

\item{...}{Additional arguments to be passed to
\link[ReducedExperiment]{runICA}.}
}
\value{
Returns a list containing:
\describe{
\item{stability}{A data.frame indicating factor stabilities as a function
of the number of components.}
\item{selected_nc}{a naive estimate for the optimal number of components
based on the \code{mean_stability_threshold}.}
}
}
\description{
Estimates the stability of factors over a range of component numbers to
aid in the identification of the optimal factor number. Based on the
Most Stable Transcriptome Dimension (MSTD) approach (see \code{details}).
}
\details{
Runs the stability-based ICA algorithm
(see \link[ReducedExperiment]{runICA}) for a range of component numbers.
Estimates stability for each, allowing for selection of the optimal
number of components to be used for ICA. The results of this function
can be plotted by \link[ReducedExperiment]{plotStability}.

This algorithm is based on the Most Stable Transcriptome
Dimension (MSTD) approach
(\url{https://bmcgenomics.biomedcentral.com/articles/10.1186/s12864-017-4112-9}).

The function automatically selects a number of components based on
\code{mean_stability_threshold}. However, this choice should be made after
visualisating the stabilities as a function of the number of components,
which may be done using \link[ReducedExperiment]{plotStability}. The
aformentioned MSTD paper provides additional context and advice for choosing
the number of components based on these results.
}
\examples{
# Get a random matrix with rnorm, with 200 rows (features)
# and 100 columns (observations)
X <- ReducedExperiment:::.makeRandomData(200, 100, "feature", "obs")

# Estimate stability across 10 to 30 components
# Note: We could have provided a SummarizedExperiment object instead of a matrix
stab_res_1 <- estimateStability(
    X,
    min_components = 10,
    max_components = 30,
    n_runs = 5,
    verbose = FALSE
)

}
\seealso{
\code{\link[=runICA]{runICA()}}, \code{\link[=plotStability]{plotStability()}}
}
\author{
Jack Gisby
}
