% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{assessSoftThreshold}
\alias{assessSoftThreshold}
\title{Assess soft thresholding power for WGCNA}
\usage{
assessSoftThreshold(
  X,
  assay_name = "normal",
  powerVector = 1:30,
  RsquaredCut = 0.85,
  max_mean_connectivity = 100,
  cor_type = "pearson",
  networkType = "signed",
  maxBlockSize = 30000,
  verbose = 0,
  ...
)
}
\arguments{
\item{X}{Either a \link[SummarizedExperiment]{SummarizedExperiment} object
or a matrix containing data to be subject to WGCNA. \code{X} should have rows as
features and columns as samples.}

\item{assay_name}{If \code{X} is a
\link[SummarizedExperiment]{SummarizedExperiment}, then this should be the
name of the assay to be subject to WGCNA.}

\item{powerVector}{ a vector of soft thresholding powers for which the scale free topology fit indices
are to be calculated. }

\item{RsquaredCut}{ desired minimum scale free topology fitting index \eqn{R^2}. }

\item{max_mean_connectivity}{The maximal mean connectivity required. Used
to select the soft-thresholding power.}

\item{cor_type}{The type of correlation to be used to generate a correlation
matrix during network formation. One of "pearson" (\link[WGCNA]{cor}) and
"bicor" (\link[WGCNA]{bicor}).}

\item{networkType}{ network type. Allowed values are (unique abbreviations of) \code{"unsigned"},
\code{"signed"}, \code{"signed hybrid"}. See \code{\link[WGCNA]{adjacency}}. }

\item{maxBlockSize}{The chunk size (in terms of the number of features/genes)
to process the data. The default (30000) should process standard
transcriptomic
datasets in a single chunk. Results may differ if the number of features
exceeds the chunk size. Lower values of this parameter will use less memory
to calculate networks.}

\item{verbose}{ integer level of verbosity. Zero means silent, higher values make the output
progressively more and more verbose. }

\item{...}{Additional arguments to be passed to
\link[WGCNA]{pickSoftThreshold}.}
}
\value{
Returns a \code{data.frame},
generated by \link[WGCNA]{pickSoftThreshold},
with scale free topology fitting indices and connectivity statistics.
Additionally contains a column, \code{estimated_power}, indicating the
recommended power to use (see \code{details}). We suggest manually considering
suitability of the soft-thresholding power rather than solely relying on this
automated approach.
}
\description{
A wrapper around \link[WGCNA]{pickSoftThreshold}, allowing assessment and
automatic selection of soft-thresholding power. Extends the function to
accept a \link[SummarizedExperiment]{SummarizedExperiment} as input and
additionally considers mean connectivity when selecting the
soft-thresholding power to recommend.
}
\details{
The \link[WGCNA]{pickSoftThreshold} function estimates the power by
selecting the lowest value with
a minimum scale free topology fitting index exceeding \code{RsquaredCut}.
The \code{assessSoftThreshold} function mirrors this behaviour when
\code{max_mean_connectivity} is \code{NULL}. When \code{max_mean_connectivity} is
specified, however, we additionally require that the selected power
does not exceed this connectivity threshold.
}
\examples{
# Get the airway data as a SummarizedExperiment (with a subset of features)
set.seed(2)
airway_se <- ReducedExperiment:::.getAirwayData(n_features = 500)

# Select soft-thresholding power to use (use capture.output to hide WGCNA's prints)
WGCNA::disableWGCNAThreads()
invisible(capture.output(fit_indices <- assessSoftThreshold(airway_se)))

print(fit_indices)
print(paste0("Estimated power: ", fit_indices$Power[fit_indices$estimated_power]))

}
\seealso{
\code{\link[WGCNA:pickSoftThreshold]{WGCNA::pickSoftThreshold()}},
\code{\link[=runWGCNA]{runWGCNA()}}
}
\author{
Jack Gisby
}
