% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedWrappers.R
\name{updateLayoutFromRedeR}
\alias{updateLayoutFromRedeR}
\title{Update graph layout}
\usage{
updateLayoutFromRedeR(g, delNodes = FALSE, delEdges = FALSE)
}
\arguments{
\item{g}{An igraph object, which will be updated with the graph layout
displayed in the RedeR interface. Note: 'g' must be the same igraph object
sent to the RedeR interface by the\code{\link{addGraphToRedeR}} function.}

\item{delNodes}{Option to delete nodes from 'g' when these nodes are
not displayed in the RedeR interface.}

\item{delEdges}{Option to delete edges from 'g' when these edges are not
displayed in the RedeR interface.}
}
\value{
An updated igraph object.
}
\description{
This function updates node coordinates of an igraph object
with the node coordinates from the RedeR interface.
}
\examples{
# Load RedeR and igraph
library(RedeR)
library(igraph)

# Create an igraph
gtoy1 <- graph.lattice(c(3, 3, 3))

\donttest{
# Start the RedeR interface
startRedeR()

# Send graph to RedeR
addGraphToRedeR(g = gtoy1)

# Update 'gtoy1' with changes introduced in the RedeR interface
gtoy2 <- updateLayoutFromRedeR(g = gtoy1)
}

}
\seealso{
\code{\link{startRedeR}}, \code{\link{addGraphToRedeR}}
}
\author{
Sysbiolab.
}
