% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedOtherMethods.R
\docType{methods}
\name{selectEdges,character-method}
\alias{selectEdges,character-method}
\alias{selectEdges}
\alias{selectEdges,data.frame-method}
\title{selectEdges}
\usage{
\S4method{selectEdges}{character}(edges, ...)

\S4method{selectEdges}{data.frame}(edges, ...)
}
\arguments{
\item{edges}{A vertex sequence <vector of strings> or data frame of ncol=2.}

\item{...}{Arguments passed to internal checks (ignore).}
}
\value{
Mark edges -- which can be handled by other methods.
}
\description{
Select edges in an active RedeR application.
}
\examples{
# Load RedeR and igraph
library(RedeR)
library(igraph)

# Create some edges as a data.frame
edges <- data.frame(
    A = c("n1", "n1", "n1", "n1"),
    B = c("n2", "n3", "n4", "n5")
)

\donttest{
# Start the RedeR interface
startRedeR()

# Add and select edges
addEdges(edges)
selectEdges(c("n1", "n3"))
}

}
\seealso{
\code{\link{addGraphToRedeR}}, \code{\link{getGraphFromRedeR}}.
}
\author{
Sysbiolab.
}
