% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportedWrappers.R
\name{relaxRedeR}
\alias{relaxRedeR}
\title{Relax}
\usage{
relaxRedeR(
  p1 = 100,
  p2 = 100,
  p3 = 100,
  p4 = 100,
  p5 = 100,
  p6 = 10,
  p7 = 10,
  p8 = 100,
  p9 = 10
)
}
\arguments{
\item{p1}{Edge target length (unit in points; >= 1 ) <numeric>.}

\item{p2}{Edge stiffness (arbitrary unit; >= 0 ) <numeric>.}

\item{p3}{Node repulsion factor (arbitrary unit; >= 0 ) <numeric>.}

\item{p4}{Node perimeter effect (unit in points; >= 0 ) <numeric>.}

\item{p5}{Node speed limit (arbitrary unit; >= 0 ) <numeric>.}

\item{p6}{Repulsion radius, i.e., this parameter limits the repulsion
factor range (unit as in 'p1'; >= 0 ) <numeric>.}

\item{p7}{Central pull (arbitrary unit; >= 0 ) <numeric>.}

\item{p8}{Nest-nest edge target length, i.e., edge target between
linked containers (unit in points; >= 1 ) <numeric>.}

\item{p9}{Nest-node repulsion factor, i.e., repulsion among containers and
out-nodes (arbitrary unit; >= 0 ) <numeric>.}
}
\value{
Layout a graph in the app panel.
}
\description{
RedeR's hierarchical force-directed interactive layout.
}
\details{
RedeR's interactive layout uses a force-directed algorithm
described elsewhere (Brandes 2001; Fruchterman and Reingold 1991). Here
we adapted the method to deal with nested networks. In force-directed
graphs, each edge can be regarded as a spring - with a given target
length - and can either exert a repulsive or attractive force on the
connected nodes, while nodes are analogous to mutually repulsive charged
particles that move according to the applied forces. In RedeR, the
simulation is additionally constrained by the hierarchical structure
of the network. For example, a nested node is constrained to its
parent-node by opposing forces applied by the nest, which is regarded
as a special node whose nested objects can reach a local equilibrium
independently from other network levels. The simulation is adjusted by
global options and evolves until the system reaches the equilibrium state.
The default values are set to layout sparse networks with few nodes
(e.g. 10-100 nodes). For large and dense networks better results can
be achieved interactively by tuning one or more parameters.
}
\examples{
# Load RedeR and igraph
library(RedeR)
library(igraph)

# Create an igraph
gtoy <- graph.lattice(c(5, 5, 5))

\donttest{
# Start the RedeR interface
startRedeR()

# Send the igraph to RedeR
addGraphToRedeR(g = gtoy)

# Start interactive layout
relaxRedeR()
}

}
\references{
Brandes U. Drawing graphs: methods and models. In: Lecture notes in computer
science. Kaufmann M. and Wagner D. (Ed), vol. 2025. Heidelberg:
Springer; 2001: 71-86.

Fruchterman TMJ, Reingold EM. Graph drawing by force-directed placement.
Software: Practice and Experience 1991, 21(11):1129-1164.
}
\seealso{
\code{\link{startRedeR}}, \code{\link{addGraphToRedeR}}
}
\author{
Sysbiolab.
}
